// Copyright 2023 Specter Ops, Inc.
//
// Licensed under the Apache License, Version 2.0
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// SPDX-License-Identifier: Apache-2.0

package schema

import (
	"pkg.specterops.io/schemas/bh/ad:ad"
	"pkg.specterops.io/schemas/bh/types:types"
	"pkg.specterops.io/schemas/bh/azure:azure"
	"pkg.specterops.io/schemas/bh/common:common"
)

// Schema
#Common: {
	Properties: [...types.#StringEnum]
	NodeKinds: [...types.#Kind]
	RelationshipKinds: [...types.#Kind]
	InboundRelationshipKinds: [...types.#Kind]
	OutboundRelationshipKinds: [...types.#Kind]
}

#Azure: {
	Properties: [...types.#StringEnum]
	NodeKinds: [...types.#Kind]
	RelationshipKinds: [...types.#Kind]
	AppRoleTransitRelationshipKinds: [...types.#Kind]
	AbusableAppRoleRelationshipKinds: [... types.#Kind]
	ControlRelationshipKinds: [...types.#Kind]
	ExecutionPrivilegeKinds: [...types.#Kind]
	PathfindingRelationships: [...types.#Kind]
	InboundOutboundRelationshipKinds: [...types.#Kind]
	PostProcessedRelationships: [...types.#Kind]
}

#ActiveDirectory: {
	Properties: [...types.#StringEnum]
	NodeKinds: [...types.#Kind]
	RelationshipKinds: [...types.#Kind]
	ACLRelationships: [...types.#Kind]
	IngestACLRelationships: [...types.#Kind]
	PathfindingRelationships: [...types.#Kind]
	PathfindingRelationshipsMatchFrontend: [...types.#Kind]
	InboundRelationshipKinds: [...types.#Kind]
	OutboundRelationshipKinds: [...types.#Kind]
	EdgeCompositionRelationships: [...types.#Kind]
	PostProcessedRelationships: [...types.#Kind]
}

// Definitons
Common: #Common & {
	Properties:        common.Properties
	NodeKinds:         common.NodeKinds
	RelationshipKinds: common.RelationshipKinds
	InboundRelationshipKinds: common.InboundRelationshipKinds
	OutboundRelationshipKinds: common.OutboundRelationshipKinds
}

Azure: #Azure & {
	Properties:                       azure.Properties
	NodeKinds:                        azure.NodeKinds
	RelationshipKinds:                azure.RelationshipKinds
	AppRoleTransitRelationshipKinds:  azure.AppRoleTransitRelationshipKinds
	AbusableAppRoleRelationshipKinds: azure.AbusableAppRoleRelationshipKinds
	ControlRelationshipKinds:         azure.ControlRelationshipKinds
	ExecutionPrivilegeKinds:          azure.ExecutionPrivilegeKinds
	PathfindingRelationships:         azure.PathfindingRelationships
	InboundOutboundRelationshipKinds: azure.InboundOutboundRelationshipKinds
	PostProcessedRelationships:       azure.PostProcessedRelationships
}

ActiveDirectory: #ActiveDirectory & {
	Properties:                   ad.Properties
	NodeKinds:                    ad.NodeKinds
	RelationshipKinds:            ad.RelationshipKinds
	ACLRelationships:             ad.ACLRelationships
	IngestACLRelationships:       ad.IngestACLRelationships
	PathfindingRelationships:     ad.PathfindingRelationships
	PathfindingRelationshipsMatchFrontend: ad.PathfindingRelationshipsMatchFrontend
	InboundRelationshipKinds:     ad.InboundRelationshipKinds
	OutboundRelationshipKinds:    ad.OutboundRelationshipKinds
	EdgeCompositionRelationships: ad.EdgeCompositionRelationships
	PostProcessedRelationships:   ad.PostProcessedRelationships
}
