"use strict";
exports.de = void 0;
var _index = require("./de/_lib/formatDistance.js");
var _index2 = require("./de/_lib/formatLong.js");
var _index3 = require("./de/_lib/formatRelative.js");
var _index4 = require("./de/_lib/localize.js");
var _index5 = require("./de/_lib/match.js");

/**
 * @category Locales
 * @summary German locale.
 * @language German
 * @iso-639-2 deu
 * @author Thomas Eilmsteiner [@DeMuu](https://github.com/DeMuu)
 * @author Asia [@asia-t](https://github.com/asia-t)
 * @author Van Vuong Ngo [@vanvuongngo](https://github.com/vanvuongngo)
 * @author RomanErnst [@pex](https://github.com/pex)
 * @author Philipp Keck [@Philipp91](https://github.com/Philipp91)
 */
const de = (exports.de = {
  code: "de",
  formatDistance: _index.formatDistance,
  formatLong: _index2.formatLong,
  formatRelative: _index3.formatRelative,
  localize: _index4.localize,
  match: _index5.match,
  options: {
    weekStartsOn: 1 /* Monday */,
    firstWeekContainsDate: 4,
  },
});
