import { ParseResultElement, Element } from '@swagger-api/apidom-core';
import File from './File';
import ReferenceSet from './ReferenceSet';
import * as url from './util/url';
export { url };
export { default as Parser } from './parse/parsers/Parser';
export type { ParserOptions } from './parse/parsers/Parser';
export { default as Resolver } from './resolve/resolvers/Resolver';
export { default as HTTPResolver } from './resolve/resolvers/HTTPResolver';
export { default as ResolveStrategy } from './resolve/strategies/ResolveStrategy';
export type { ResolverOptions } from './resolve/resolvers/Resolver';
export type { ResolveStrategyOptions } from './resolve/strategies/ResolveStrategy';
export { default as DereferenceStrategy } from './dereference/strategies/DereferenceStrategy';
export type { DereferenceStrategyOptions } from './dereference/strategies/DereferenceStrategy';
export { AncestorLineage as DereferenceAncestorLineage } from './dereference/util';
export { default as BundleStrategy } from './bundle/strategies/BundleStrategy';
export type { BundleStrategyOptions } from './bundle/strategies/BundleStrategy';
export { default as options } from './options';
export { merge as mergeOptions } from './options/util';
export { File };
export { default as Reference } from './Reference';
export { ReferenceSet };
export type { FileOptions } from './File';
export type { ReferenceOptions } from './Reference';
export type { ReferenceSetOptions } from './ReferenceSet';
export { default as BundleError } from './errors/BundleError';
export { default as MaximumBundleDepthError } from './errors/MaximumBundleDepthError';
export { default as UnmatchedBundleStrategyError } from './errors/UnmatchedBundleStrategyError';
export { default as DereferenceError } from './errors/DereferenceError';
export { default as EvaluationElementIdError } from './errors/EvaluationElementIdError';
export { default as EvaluationJsonSchema$anchorError } from './errors/EvaluationJsonSchema$anchorError';
export { default as EvaluationJsonSchemaUriError } from './errors/EvaluationJsonSchemaUriError';
export { default as InvalidJsonSchema$anchorError } from './errors/InvalidJsonSchema$anchorError';
export { default as JsonSchema$anchorError } from './errors/JsonSchema$anchorError';
export { default as JsonSchemaURIError } from './errors/JsonSchemaUriError';
export { default as MaximumDereferenceDepthError } from './errors/MaximumDereferenceDepthError';
export { default as MaximumResolveDepthError } from './errors/MaximumResolveDepthError';
export { default as ParseError } from './errors/ParseError';
export { default as ParserError } from './errors/ParserError';
export { default as PluginError } from './errors/PluginError';
export { default as ResolveError } from './errors/ResolveError';
export { default as ResolverError } from './errors/ResolverError';
export { default as UnmatchedDereferenceStrategyError } from './errors/UnmatchedDereferenceStrategyError';
export { default as UnmatchedResolveStrategyError } from './errors/UnmatchedResolveStrategyError';
export { default as UnmatchedResolverError } from './errors/UnmatchedResolverError';
export declare const readFile: (uri: string, options?: {}) => Promise<Buffer>;
export declare const parse: (uri: string, options?: {}) => Promise<ParseResultElement>;
export declare const resolve: (uri: string, options?: {}) => Promise<ReferenceSet>;
export declare const resolveApiDOM: <T extends Element>(element: T, options?: {}) => Promise<ReferenceSet>;
export declare const dereference: (uri: string, options?: {}) => Promise<ParseResultElement>;
export declare const dereferenceApiDOM: <T extends Element>(element: T, options?: {}) => Promise<T>;
export declare const bundle: (uri: string, options?: {}) => Promise<ParseResultElement>;
