#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Stacking
# send your bug reports to bugs@dotslashplay.it
###

script_version=20241219.2

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='stacking'
GAME_NAME='Stacking'

ARCHIVE_BASE_HUMBLE_0_NAME='Stacking-Linux-2013-06-04-setup.bin'
ARCHIVE_BASE_HUMBLE_0_MD5='4194bb869d537d40da7ad7f65b1102ed'
## This is a MojoSetup installer not relying on a Makeself wrapper.
ARCHIVE_BASE_HUMBLE_0_EXTRACTOR='bsdtar'
ARCHIVE_BASE_HUMBLE_0_SIZE='1505540'
ARCHIVE_BASE_HUMBLE_0_VERSION='2013.06.04-humble160616'
ARCHIVE_BASE_HUMBLE_0_URL='https://www.humblebundle.com/store/stacking'

ARCHIVE_BASE_GOG_0_NAME='gog_stacking_2.0.0.4.sh'
ARCHIVE_BASE_GOG_0_MD5='c32245091358bd97ac3e73c7f8bb937b'
## FIXME: The size of the archive content sould be included.
ARCHIVE_BASE_GOG_0_VERSION='1.0-gog2.0.0.4'
ARCHIVE_BASE_GOG_0_URL='https://www.gog.com/game/stacking'

CONTENT_PATH_DEFAULT_HUMBLE='data'
CONTENT_PATH_DEFAULT_GOG='data/noarch/game'
CONTENT_LIBS_BIN_RELATIVE_PATH='lib'
CONTENT_LIBS_BIN_FILES='
libfmodevent-4.42.16.so
libfmodeventnet-4.42.16.so
libfmodex-4.42.16.so'
CONTENT_GAME_BIN_FILES='
Stack.bin.x86'
CONTENT_GAME_DATA_FILES='
Data
Linux
OGL
Win
Stack.png
DFCONFIG'

APP_MAIN_EXE='Stack.bin.x86'
APP_MAIN_ICON='Stack.png'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libGLU.so.1
libm.so.6
libpthread.so.0
libSDL2-2.0.so.0
libstdc++.so.6
libz.so.1'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build package

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
